% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedtrace_CI.R
\name{conf_fixedtrace}
\alias{conf_fixedtrace}
\alias{conf_fixedtrace_inregion}
\title{Eigenvalue confidence region under fixed trace constraint}
\usage{
conf_fixedtrace(x, alpha = 0.05, B = 1000, npts = 1000, check = TRUE)

conf_fixedtrace_inregion(evals, cr)
}
\arguments{
\item{x}{A single sample of 3x3 symmetric matrices. \code{x} must be either an \code{\link{fsm}} object or something that \code{\link[=as_fsm]{as_fsm()}} can parse.}

\item{alpha}{Desired significance level of the approximate confidence region.}

\item{B}{Number of bootstrap resamples.}

\item{npts}{Number of points on the boundary of the region to compute.}

\item{check}{If \code{TRUE}, then the extrinsic means of 100 new resamples will be used to check the coverage of the region.}

\item{evals}{A set of eigenvalues with the same trace as matrices in \code{x}.}

\item{cr}{A confidence region returned by \code{\link[=conf_fixedtrace]{conf_fixedtrace()}}.}
}
\value{
A list:
\itemize{
\item \code{est}: the eigenvalues of the mean matrix.
\item \code{boundary}: A matrix with 3 columns and \code{npts} rows giving the boundary of the region. Each row corresponds to a point on the boundary and the columns are the first, second and final eigenvalue.
\item \code{Omega}: The estimated covariance of the (projected) eigenvalues
\item \code{threshold}: The threshold (estimated via resampling) on the statistic.
}
}
\description{
When a 3x3 symmetric matrix has a fixed-trace constraint, the vector of its eigenvalues lies on a 2D plane.
This function calculates the boundary of an approximate confidence region in this 2D plane using the same statistic as \code{\link[=test_fixedtrace]{test_fixedtrace()}}.
The returned boundary can be used to plot the confidence region.
The function \code{\link[=conf_fixedtrace_inregion]{conf_fixedtrace_inregion()}} returns where given points are in the estimated confidence region.
}
\details{
Uses the same statistic as \code{\link[=test_fixedtrace]{test_fixedtrace()}} and bootstrap resampling to obtain approximate bounds on the eigenvalues of a population mean.
The statistic has a quadratic form so that the boundary of the confidence region is an ellipse, but for plotting simplicity the ellipse is returned as a dense set of \code{npts} points.
A warning will be generated if the confidence region leaves the space of distinct descending-order eigenvalues and a check of coverage of bootstrap resamples is available.
}
