% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICSKATPO.R
\name{ICskatPO}
\alias{ICskatPO}
\title{ICSKATPO.R}
\usage{
ICskatPO(
  left_dmat,
  right_dmat,
  lt,
  rt,
  obs_ind,
  tpos_ind,
  gMat,
  null_beta,
  Itt
)
}
\arguments{
\item{left_dmat}{n*(p+nknots+2) design matrix for left end of interval.}

\item{right_dmat}{n*(p+nknots+2) design matrix for right end of interval.}

\item{lt}{n*1 vector of left side of interval times.}

\item{rt}{n*1 vector of right side of interval times.}

\item{obs_ind}{n*1 vector of whether the event was observed before last follow-up.}

\item{tpos_ind}{n*1 vector of whether the event was observed after follow-up started (t>0).}

\item{gMat}{n*q genotype matrix.}

\item{null_beta}{(p+nknots+2)*1 vector of coefficients for null model.}

\item{Itt}{(p+nknots+2)*(p+nknots+2) Fisher information matrix for null model coefficients.}
}
\value{
A list with the elements:
\item{p_SKAT}{ICSKAT p-value for PO model.}
\item{p_burden}{IC burden test p-value for PO model.}
\item{complex}{Indicator of whether the SKAT variance matrix was positive definite}
\item{sig_mat}{The covariance matrix of the score equations for genetic effects when treated as fixed effects}
\item{skatQ}{SKAT test statistic.}
\item{burdenQ}{Burden test statistic.}
\item{err}{err=1 for a bad null fit.}
\item{errMsg}{Describes the error.}
}
\description{
Calculate the test statistic and p-value for interval-censored skat with PO model.
}
\examples{
set.seed(0)
gMat <- matrix(data=rbinom(n=2000, size=2, prob=0.3), nrow=100)
xMat <- matrix(data=rnorm(200), nrow=100)
bhFunInv <- function(x) {x}
obsTimes <- 1:5
etaVec <- rep(0, 100)
outcomeDat <- gen_IC_data(bhFunInv = bhFunInv, obsTimes = obsTimes, windowHalf = 0.1,
probMiss = 0.1, etaVec = etaVec)
lt <- outcomeDat$leftTimes
rt <- outcomeDat$rightTimes
tpos_ind <- as.numeric(lt > 0)
obs_ind <- as.numeric(rt != Inf)
dmats <- make_IC_dmat(xMat, lt, rt, obs_ind, tpos_ind)
nullFit <- ICSKAT_fit_null(init_beta = rep(0.1, 5), left_dmat = dmats$left_dmat,
right_dmat=dmats$right_dmat, obs_ind = obs_ind, tpos_ind = tpos_ind, lt = lt, rt = rt)
ICskatPO(left_dmat = dmats$left_dmat, right_dmat=dmats$right_dmat, lt = lt, rt = rt,
obs_ind = obs_ind, tpos_ind = tpos_ind, gMat = gMat, null_beta = nullFit$beta_fit,
Itt = nullFit$Itt)

}
