% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vn.entropy.R
\name{vn.entropy}
\alias{vn.entropy}
\title{Entropy Fit Index using Von Neumman's entropy (Quantum Information Theory) for correlation matrices}
\usage{
vn.entropy(data, structure)
}
\arguments{
\item{data}{Matrix or data frame.
Contains variables to be used in the analysis}

\item{structure}{Numeric or character vector (length = \code{ncol(data)}).
A vector representing the structure (numbers or labels for each item).
Can be theoretical factors or the structure detected by \code{\link[EGAnet]{EGA}}}
}
\value{
Returns a list containing:

\item{VN.Entropy.Fit}{The Entropy Fit Index using Von Neumman's entropy}

\item{Total.Correlation}{The total correlation of the dataset}

\item{Average.Entropy}{The average entropy of the dataset}
}
\description{
Computes the fit of a dimensionality structure using Von Neumman's 
entropy when the input is a correlation matrix. Lower values suggest better 
fit of a structure to the data
}
\examples{
# Get EGA result
ega.wmt <- EGA(
  data = wmt2[,7:24], model = "glasso",
  plot.EGA = FALSE # no plot for CRAN checks
)

# Compute Von Neumman entropy
vn.entropy(ega.wmt$correlation, ega.wmt$wc)

}
\references{
\strong{Initial formalization and simulation} \cr
Golino, H., Moulder, R. G., Shi, D., Christensen, A. P., Garrido, L. E., Nieto, M. D., Nesselroade, J., Sadana, R., Thiyagarajan, J. A., & Boker, S. M. (2020).
Entropy fit indices: New fit measures for assessing the structure and dimensionality of multiple latent variables.
\emph{Multivariate Behavioral Research}.
}
\author{
Hudson Golino <hfg9s at virginia.edu>, Alexander P. Christensen <alexpaulchristensen@gmail.com>, and Robert Moulder <rgm4fd@virginia.edu>
}
