% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_priortised_oagenes.R
\name{view_prioritised_oagenes}
\alias{view_prioritised_oagenes}
\title{View prioritised osteoarthritis associated genes}
\usage{
view_prioritised_oagenes(skeletalvis)
}
\arguments{
\item{skeletalvis}{The path to the SkeletalVis folder.}
}
\value{
A data frame with the following columns:
\describe{
  \item{Gene}{The human gene symbol.}
  \item{Rank}{The rank of the priortisation scores from the machine learning model}
  \item{PredictedEffect}{The predicted effect this gene}
  \item{Category_sm}{The small molecular tractibility of this gene}
  \item{Category_ab}{The antibody tractibility of this gene}
}
}
\description{
Retrieves the machine learning model prioritised table of osteoarthritis joint damage in animals.
Genes are ranked by their probability to cause an OA damage phenotype when experimentally perturbed.
The predicted direction of effect and druggability of that gene is also provided.
}
\examples{
skeletalvis <- load_skeletalvis(demo=TRUE)
oatargets <- view_prioritised_oagenes(skeletalvis)

}
