% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDepthLayerMasks.R
\name{createDepthLayerMasks}
\alias{createDepthLayerMasks}
\alias{dissectionLine}
\title{Create masking layers for the depth layers}
\usage{
createDepthLayerMasks(
  ppcm = NULL,
  ppi = NULL,
  dims_px,
  depth_levels_cm = rbind(c(0, -10), c(-10, -20), c(-20, -30), c(-30, -40)),
  depth_highpoint_cm = 0,
  pos_highpoint_px = "center",
  angle = 45,
  top_side = "top",
  gap_cm = 0,
  gap_deg = 0
)

dissectionLine(x, minpoint, angle, radius)
}
\arguments{
\item{ppcm}{Numeric value specifying how many pixels there are per
centimeter (resolution of the image). Default NULL.
If \code{ppcm} is not NULL or NA, \code{ppi} is ignored.\cr
Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
72 ppi (screens) is 28 ppcm.}

\item{ppi}{Numeric value specifying how many pixels there are per inch
(resolution of the image). Default NULL.
Leave/set \code{ppcm} to NULL or NA to use \code{ppi}.\cr
Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
72 ppi (screens) is 28 ppcm.}

\item{dims_px}{Integer vector of length two
specifying the dimensions of the image/mask layer (in pixels).}

\item{depth_levels_cm}{Numeric matrix with two columns and at least
one row. Each row specifies a depth interval (in cm) that is of
interest. For each interval a masking layer is generated. The first value
of each row has to be larger than the second (decending).\cr
By default: Depth layers Depth layers 0-(-10)cm, -10-(-20)cm, -20-(-30)cm,
and -30-(-40)cm.}

\item{depth_highpoint_cm}{Numeric value specifying the depth at which the
highest point of the image is (in cm).
By default this is at depth 0.\cr
More precisely, this refers to the depth of the middle of the pixel in the
first row of the \code{top_side} of the image.}

\item{pos_highpoint_px}{Either one of "center" or "edge" (default),
indicating that scanning starts at the bottom or top facing side of the
minirhizotron, respectively, or it can also be an integer value (>=1 and
<=width of the \code{top_side} of the image) specifying where (left<->right)
in the top row of the image the highest point of the image lies, indicating
the column where the minimum points of the depth-level lines lie. \cr
"edge" is equivalent to using 1 or width of the \code{top_side} and
"center" to using half the width of the \code{top_side}.\cr
See also \code{gap_cm} if there is a non-zero gap.}

\item{angle}{Numeric value >=0 and <=90 (default 45) specifying the
installation angle of the minirhizotron in degrees (angle between the ground
and the tube above the soil).}

\item{top_side}{One of "left","top" (default),"right","bottom". Indicates
where the upper side of the image is.}

\item{gap_cm}{Numeric value (default 0) that specifies if there is a gap
(in cm) between the two "matching" sides of the image, i.e., there is no full
rotation of the scanner. If \code{pos_highpoint_px} is specified as "center"
or "edge" (in characters), then it is assumed that the middle of the gap is
right at the top or bottom facing side of the tube, i.e. it is not possible
to start and end at the exact top/bottom. If \code{pos_highpoint_px} is
specified as a numeric value, then it is considered as exact and the gap
does not move it.}

\item{gap_deg}{Numeric value (default 0) that specifies if there is a gap
(in degrees, i.e. from 0 to 360) between the two "matching" sides
of the image, i.e., there is no full rotation of the scanner.
Works similar to \code{gap_cm}. Example: If the scanner scans only 355
degrees, then set the value to 5. \code{gap_deg} is only used if
\code{gap_cm} is NA.}

\item{x}{Numeric value indicating the position.}

\item{minpoint}{Numeric vector of length 2 indicating the coordinates of the
minimum point of the function.}

\item{radius}{Positive numeric value indicating the radius of the tube.}
}
\value{
\code{createDepthLayerMasks} A list of 2-dimensional
true/false-matrices with the specified dimensions (see \code{dims}). True
indicates that the corresponding pixel belongs to the specified depth layer.
The list contains \code{nrow(depth_levels_cm)}-many matrices, one for each
specified depth layer.

\code{dissectionLine}
}
\description{
\code{createDepthLayerMasks} - Creates a masking layer, i.e., a
true/false-matrix, indicating which pixels of an image belong to a specified
depth layer.\cr
We assume the image was taken inside a minirhizotron, a round
plexiglas tube used to observe roots in the ground, and shows a 360 degree
scan of a section of the tube. As the minirhizotron is installed at an
angle (can be specified, by default 45 degrees) a depth layer in the ground
is shown as a sinus curve in the scan.

\code{dissectionLine} - Returns the y-value of the dissection line of a
tube that was positioned at an angle for a given position x.
The dissection line is dependent on the \code{minpoint}, the \code{angle},
and the \code{radius} of the tube (have to be specified).
}
\examples{
# Small example for creating a masking layer of a single depth interval:
createDepthLayerMasks(ppcm = 1, dims_px = c(10,10),
                      depth_levels_cm = matrix(c(-3,-5), ncol = 2))[[1]]
# Change some parameters to adapt to a different minimum point position and
# installation angle.
createDepthLayerMasks(ppcm = 1, dims_px = c(5,7),
                      depth_levels_cm = matrix(c(-1.5,-2.5), ncol = 2),
                      pos_highpoint_px = "center", gap_cm = 0)[[1]]
# And here is a cutout of that mask using a gap.
createDepthLayerMasks(ppcm = 1, dims_px = c(5,5),
                      depth_levels_cm = matrix(c(-1.5,-2.5), ncol = 2),
                      pos_highpoint_px = "center", gap_cm = 2)[[1]]
# Examples how different angles result in different dissection graphs:
test_x <- -12:12
plot(test_x, sapply(X=test_x, function(X){
               dissectionLine(x=X, minpoint = c(0,0), angle = 45,
                              radius = 3)}),
     ylim = c(0, 20))
plot(test_x, sapply(X=test_x, function(X){
               dissectionLine(x=X, minpoint = c(0,0), angle = 80,
                              radius = 3)}),
     ylim = c(0, 20))
plot(test_x, sapply(X=test_x, function(X){
               dissectionLine(x=X, minpoint = c(0,0), angle = 10,
                              radius = 3)}),
     ylim = c(0, 20))
}
