% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvh_subbasin_visnetwork_plot.R
\name{rvn_rvh_subbasin_visnetwork_plot}
\alias{rvn_rvh_subbasin_visnetwork_plot}
\title{Plot subbasin network using visNetwork}
\usage{
rvn_rvh_subbasin_visnetwork_plot(rvh, groupBy = "Gauged")
}
\arguments{
\item{rvh}{an \code{rvh} object, provided by \code{rvn_rvh_read}}

\item{groupBy}{a character referring to one of the sub-basins attributes in the \code{rvh}}
}
\value{
returns visNetwork plot object
}
\description{
Takes an \code{rvh} object generated using \code{rvn_rvh_read}
and returns the connections information of subbasins as an interactive visNetwork graph.
}
\examples{
## additional example from tutorial files (not run)
\dontrun{
  path <- dirname(tempfile())
  dir.create(paste(path,"/tmp",sep=""))
  url<-"https://raven.uwaterloo.ca/files/RavenOstrichTutorialFiles.zip"
  download.file(url,dest=paste(path,"/tmp/example.zip",sep=""))
  unzip(zipfile = paste(path,"/tmp/example.zip",sep=""),
        exdir = paste(path,"/tmp",sep=""))
  rvh<-rvn_rvh_read(paste(path,"/tmp/Demo_C4/model/LOWRL.rvh",sep=""))
  rvn_rvh_subbasin_visnetwork_plot(rvh,groupBy="Gauged")
  rvn_rvh_subbasin_visnetwork_plot(rvh,groupBy="DomLU")
  rvn_rvh_subbasin_visnetwork_plot(rvh,groupBy="Elevation")
  }

rvh <- rvn_rvh_read(system.file("extdata","Nith.rvh", package="RavenR"))
rvn_rvh_subbasin_visnetwork_plot(rvh,groupBy="Gauged")
rvn_rvh_subbasin_visnetwork_plot(rvh,groupBy="Elevation")

}
\seealso{
\code{\link{rvn_rvh_read}} to import an watershed network table from an \code{rvh} file.

See also the \href{https://raven.uwaterloo.ca/}{Raven page}
}
