% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{PreProcessing}
\alias{PreProcessing}
\title{Preprocess the input to a classification function}
\usage{
PreProcessing(X, y, X_u = NULL, scale = FALSE, intercept = FALSE,
  x_center = FALSE, use_Xu_for_scaling = TRUE)
}
\arguments{
\item{X}{Design matrix, intercept term is added within the function}

\item{y}{Vector or factor with class assignments}

\item{X_u}{Design matrix of the unlabeled observations}

\item{scale}{If TRUE, apply a z-transform to the design matrix X}

\item{intercept}{Whether to include an intercept in the design matrices}

\item{x_center}{logical (default: TRUE); Whether the feature vectors should be centered}

\item{use_Xu_for_scaling}{logical (default: TRUE); Should the unlabeled data be used to determine scaling?}
}
\value{
list object with the following objects:
\item{X}{design matrix of the labeled data}
\item{y}{integer vector indicating the labels of the labeled data}
\item{X_u}{design matrix of the unlabeled data}
\item{classnames}{names of the classes corresponding to the integers in y}
\item{scaling}{a scaling object used to scale the test observations in the same way as the training set}
\item{modelform}{a formula object containing the used model}
}
\description{
The following actions are carried out: 1. data.frames are converted to matrix form and labels converted to an indicator matrix 2. An intercept column is added if requested 3. centering and scaling is applied if requested.
}
