% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_split.R
\name{rd_split}
\alias{rd_split}
\title{Split a REDCap dataset by form or event}
\usage{
rd_split(
  project = NULL,
  data = NULL,
  dic = NULL,
  event_form = NULL,
  which = NULL,
  by = "form",
  wide = FALSE
)
}
\arguments{
\item{project}{A list containing the REDCap data, dictionary, and event mapping (expected \code{redcap_data()} output). Overrides \code{data}, \code{dic}, and \code{event_form}.}

\item{data}{A \code{data.frame} or \code{tibble} with the REDCap dataset.}

\item{dic}{A \code{data.frame} with the REDCap dictionary.}

\item{event_form}{Only applicable for longitudinal projects (presence of events). Event-to-form mapping for longitudinal projects.}

\item{which}{Optional. A single form or event to extract. If not provided, all forms or events are returned.}

\item{by}{Character. Criteria to split the dataset: \code{"form"} (default) or \code{"event"}.}

\item{wide}{Logical. If \code{TRUE} (for form-based splits), repeated instances are returned in wide format. Defaults to \code{FALSE}.}
}
\value{
Depending on \code{which} and \code{wide}:
\describe{
\item{data}{A \code{data.frame} or a list of \code{data.frames} representing the split datasets.}
\item{dictionary}{The original REDCap dictionary.}
\item{event_form}{The original event-form mapping (if applicable).}
\item{results}{A summary message of the splitting operation.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Splits a REDCap dataset into separate datasets by \strong{form} or \strong{event} using the data dictionary. Supports both longitudinal and non-longitudinal projects and can return wide or long formats for repeated measures.
}
\details{
\itemize{
\item Handles checkbox variables and REDCap default variables (\verb{_complete}, \verb{_timestamp}) appropriately.
\item For form-based splits in longitudinal projects, uses \code{event_form} to map variables to events.
\item Wide format expands repeated instances into multiple columns per record.
\item Filtering by \code{which} allows extracting a single form or event.
\item Projects with repeated instruments are handled by filtering on the \code{redcap_repeat_instrument} variable.
}
}
\examples{
# Split by form and return wide format
result <- covican |>
  rd_split(by = "form", wide = TRUE)

print(result)

# Split by event (long format)
result <- covican |>
  rd_split(by = "event")

print(result)

}
