% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/left_join_checks.R
\name{left_join_checks}
\alias{left_join_checks}
\title{Left Join with Validation Checks}
\usage{
left_join_checks(
  x,
  y,
  ...,
  req_xAllMatch = 1,
  req_preserved_x = 1,
  behavior = "error",
  showNotFound = FALSE,
  showProblems = TRUE,
  time = FALSE
)
}
\arguments{
\item{x}{A data.table representing the left table.}

\item{y}{A data.table representing the right table.}

\item{...}{Additional arguments passed to `dplyr::left_join`.}

\item{req_xAllMatch}{Logical. Ensure that all rows in `x` find a match in `y`.
Default: FALSE.}

\item{req_preserved_x}{Logical. Ensure that the number of rows in `x`
remains unchanged after the join. Default: TRUE.}

\item{behavior}{Character. Specifies behavior if validation fails.
Options: `"warning"` or `"error"`. (default: `"warning"`)}

\item{showNotFound}{Logical. Show rows from `x` that did not match with `y`.
Default: FALSE.}

\item{showProblems}{Logical. Display the problems encountered during the
joining process, if any.}

\item{time}{Logical. Internal argument used only for testing purposes, timing
the function steps}
}
\value{
A data.table containing the joined table.
}
\description{
a custom usage of left_join, with more detailed checks.
Performs a left join and verifies that no unexpected duplicates or mismatches
 occur. In cas of unexpected results, gives details about what caused the
 problem.
}
\examples{
library(data.table)
library(dplyr)

# Example 1: Simple left join with all matches
table_left <- data.table(id = 1:3, value_left = c("A", "B", "C"))
table_right <- data.table(id = 1:3, value_right = c("X", "Y", "Z"))
result <- left_join_checks(table_left, table_right, by = "id", req_preserved_x = TRUE)
print(result) # Ensures all rows in table_left are preserved

# Example 2: Left join with missing matches
table_left <- data.table(id = 1:5, value_left = c("A", "B", "C", "D", "E"))
table_right <- data.table(id = c(1, 3, 5), value_right = c("X", "Y", "Z"))
result <- left_join_checks(
  table_left,
  table_right,
  by = "id",
  req_preserved_x = TRUE,
  showNotFound = TRUE,
  behavior = "warning"
)
print(result) # Rows from table_left with no matches in table_right are shown

}
