% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{.plot_data}
\alias{.plot_data}
\title{Internal Data Plotting Engine}
\usage{
.plot_data(
  data,
  design,
  formula,
  family,
  x_var,
  group_var,
  color_var,
  facet_var,
  n_data_points
)
}
\arguments{
\item{data}{The data frame to plot.}

\item{design}{The \code{PowRPriori_design} object.}

\item{formula}{An lme4-style formula (e.g. \code{outcome ~ predictor1 * predictor2 + (1 | subject)})}

\item{family}{The model family (e.g., \code{"gaussian"}).}

\item{x_var, group_var, color_var, facet_var}{Strings specifying variables for plot aesthetics.}

\item{n_data_points}{The maximum number of trajectories in spaghetti plots.}
}
\value{
A \code{ggplot} object.
}
\description{
An internal helper function containing the logic to "intelligently" create
plots from simulated data. It automatically chooses between spaghetti plots and jitter/point-range plots depending on
the specified design and model family.It derives sensible defaults for plot aesthetics from the design,
if they are not supplied directly via the \code{plot_sim_model} function.
}
