% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegOne.R
\name{SegOne}
\alias{SegOne}
\title{Single Tree wood leaf segmentation}
\usage{
SegOne(a, filename = "Elab_single_tree", dimVox = 2, th = 2, 
eps = 1, mpts = 4, N = 1000, R = 30, output_path = tempdir())
}
\arguments{
\item{dimVox}{- voxel dimension in cm - Default = 2}

\item{th}{- Minimum number of points to generate a voxel - Default = 2}

\item{filename}{- Output file prefix}

\item{a}{- AGB voxelized input file}

\item{eps}{- size (radius) of the epsilon neighborhood - Default = 1}

\item{mpts}{- number of minimum points required in the eps neighborhood for core points (including the point itself) - Default = 4}

\item{N}{- Minimum number of voxel in a wood cluster - Default = 1000}

\item{R}{- R = Standard deviation * Proportion of Variance - Default = 30}

\item{output_path}{Directory in cui scrivere i file di output. Default = tempdir()}
}
\value{
Two file (.txt) in output - Wood points and non wood points
}
\description{
Wood - leaf segmentation of single tree
}
