% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSPI.R
\name{SSPI}
\alias{SSPI}
\title{Stress Susceptibility Percentage Index (SSPI)}
\usage{
SSPI(Gen, YN, YS, YMN = NULL)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}

\item{YMN}{Optional numeric scalar: mean of \code{YN}. If NULL, computed.}
}
\value{
A list with \code{YMN} and \code{Result} (data frame with \code{Gen}, \code{SSPI}).

\deqn{SSPI = \frac{(YN - YS)}{2 \times YMN} \times 100}
}
\description{
This function computes Stress Susceptibility Percentage Index (SSPI) using any traits (like yield) under stress and non-stress conditions. The lower values of SSPI indicates greater tolerance. For more details see Moosavi et al. (2008).
}
\examples{
out=SSPI(Gen=c("G1","G2","G3"), YN=c(10,8,5), YS=c(7,5,3))
print(out)
}
\references{
Mousavi, S.S., YAZDI, S.B., Naghavi, M.R., Zali, A.A., Dashti, H. and Pourshahbazi, A. (2008). Introduction of new indices to identify relative drought tolerance and resistance in wheat genotypes. Desert 12, 165–178.
}
