% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureEngineering.R
\name{createRareFeatureRemover}
\alias{createRareFeatureRemover}
\title{Create the settings for removing rare features}
\usage{
createRareFeatureRemover(threshold = 0.001)
}
\arguments{
\item{threshold}{The minimum fraction of the training data that must have a
feature for it to be included}
}
\value{
An object of class \code{featureEngineeringSettings}
}
\description{
Create the settings for removing rare features
}
\examples{
\dontshow{if (rlang::is_installed("Eunomia") && rlang::is_installed("curl") && curl::has_internet()) withAutoprint(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
# create a rare feature remover that removes features that are present in less
# than 1\% of the population
rareFeatureRemover <- createRareFeatureRemover(threshold = 0.01)
plpData <- getEunomiaPlpData()
analysisId <- "rareFeatureRemover"
saveLocation <- file.path(tempdir(), analysisId)
results <- runPlp(
  plpData = plpData,
  featureEngineeringSettings = rareFeatureRemover,
  outcomeId = 3,
 executeSettings = createExecuteSettings(
   runModelDevelopment = TRUE,
   runSplitData = TRUE,
   runFeatureEngineering = TRUE),
 saveDirectory = saveLocation,
 analysisId = analysisId)
# clean up 
unlink(saveLocation, recursive = TRUE)
} 
\dontshow{\}) # examplesIf}
}
