% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_psri.R
\name{calculate_psri}
\alias{calculate_psri}
\title{Calculate Plant Stress Response Index (PSRI)}
\usage{
calculate_psri(
  germination_counts,
  time_points = c(3, 5, 7),
  total_seeds,
  species,
  radicle_summary = NULL,
  diseased_counts = NULL
)
}
\arguments{
\item{germination_counts}{Numeric vector of cumulative germination counts
at each time point (length 3 for days 3, 5, 7)}

\item{time_points}{Numeric vector of time points in days (default: c(3, 5, 7))}

\item{total_seeds}{Integer, total number of seeds in the replicate}

\item{species}{Character string, species name for identification}

\item{radicle_summary}{Optional list containing radicle data}

\item{diseased_counts}{Optional numeric vector of diseased seed counts}
}
\value{
A list containing PSRI components and metrics
}
\description{
This function calculates the Plant Stress Response Index from time-series
germination data with optional radicle vigor integration.
}
\examples{
result <- calculate_psri(
  germination_counts = c(5, 8, 10),
  time_points = c(3, 5, 7),
  total_seeds = 15,
  species = 'corn'
)
print(result$PSRI)

}
\references{
Walne, C.H., Gaudin, A., Henry, W.B., and Reddy, K.R. (2020). In vitro seed
germination response of corn hybrids to osmotic stress conditions.
Agrosystems, Geosciences & Environment, 3(1), e20087.
\doi{10.1002/agg2.20087}
}
