% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph_B_sets.R
\name{B_sets_cut_increments}
\alias{B_sets_cut_increments}
\title{Find the decomposition of B-sets}
\usage{
B_sets_cut_increments(B_sets)
}
\arguments{
\item{B_sets}{matrix of B-sets, assumed to be increasing.
This means \code{\link{find_interfering_v_from_B_sets}} should return \code{NULL}
on this matrix.
This can be the output of \code{\link{find_B_sets_v}}
or of \code{\link{B_sets_make_unique}}.}
}
\value{
a list of vectors of characters. Each element of the list
corresponds to one \eqn{DeltaBset = Bset[i] \ Bset[i-1]}.
}
\description{
Find the decomposition of B-sets
}
\examples{

B_sets = matrix(c(FALSE, FALSE, FALSE, FALSE,
                  TRUE , FALSE, FALSE, FALSE,
                  TRUE , TRUE , FALSE, FALSE,
                  TRUE , TRUE , TRUE ,  TRUE),
                nrow = 4, byrow = TRUE)

colnames(B_sets) <- c("U1", "U2", "U3", "U4")

B_sets_cut_increments(B_sets)

}
