% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{process_mea_flexible}
\alias{process_mea_flexible}
\title{Process MEA Data Flexibly}
\usage{
process_mea_flexible(
  main_dir,
  selected_experiments = NULL,
  selected_timepoints = NULL,
  grouping_variables = c("Treatment", "Genotype"),
  baseline_timepoint = NULL,
  unique_id_vars = c("Well", "Variable"),
  exclude_std_variables = TRUE,
  experiment_pattern = "MEA\\\\d+",
  timepoint_fusions = NULL,
  verbose = TRUE,
  output_path = NULL
)
}
\arguments{
\item{main_dir}{Character. Path to the main directory containing experiment folders}

\item{selected_experiments}{Character vector. Experiment names to process (default: NULL = all)}

\item{selected_timepoints}{Character vector. Timepoints to include (default: NULL = all)}

\item{grouping_variables}{Character vector. Metadata columns to include ("Treatment", "Genotype")}

\item{baseline_timepoint}{Character. Timepoint to use for normalization (default: NULL = no normalization)}

\item{unique_id_vars}{Character vector. Variables that uniquely identify observations for normalization}

\item{exclude_std_variables}{Logical. Whether to automatically exclude standard deviation variables (default: TRUE)}

\item{experiment_pattern}{Character. Regex pattern for experiment directories (default: "MEA\\d+")}

\item{timepoint_fusions}{Timepoint fusions to generate}

\item{verbose}{Logical. Whether to print progress messages (default: TRUE)}

\item{output_path}{Character. Optional path for output file (default: NULL saves to main_dir with auto-generated name)}
}
\value{
A list containing:
  - raw_data: Processed data in long format
  - normalized_data: Baseline-normalized data (if baseline_timepoint specified)
  - processing_params: List of parameters used for processing
  - output_path: Path to saved Excel file (only if output_path was provided)
  - experiment_name: Combined experiment identifier
}
\description{
This function processes Multi-Electrode Array (MEA) data files by reading CSV files,
extracting measurements and metadata, applying filters, and optionally normalizing
to baseline conditions. It automatically excludes standard deviation variables and
handles exclusion flags to produce clean, analysis-ready datasets.
}
\details{
The function automatically detects and excludes variables containing "Std", "std", or "STD"
in their names (e.g., "Number of Spikes - Std") while keeping average/mean variables
(e.g., "Number of Spikes - Avg"). Wells marked with "Ex" or "ex" in row 124 are excluded.

By default, no files are written. To save output, provide an explicit output_path parameter.
Normalization creates fold-change values relative to baseline timepoint.

Process data without saving (returns data frames only)
Save output by providing explicit path
}
