% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{pca_plots_enhanced}
\alias{pca_plots_enhanced}
\title{Enhanced PCA Plotting for Neural and Omics Data}
\usage{
pca_plots_enhanced(
  pca_output = NULL,
  plot_data = NULL,
  pca_result = NULL,
  output_dir = NULL,
  processing_result = NULL,
  experiment_name = NULL,
  grouping_variables = NULL,
  color_variable = "Treatment",
  shape_variable = "Genotype",
  secondary_shape_variable = "Timepoint",
  pannels_var = NULL,
  components = c(1, 2),
  gray_color_value = NULL,
  save_plots = FALSE,
  plot_width = 12,
  plot_height = 10,
  dpi = 300,
  verbose = TRUE
)
}
\arguments{
\item{pca_output}{List. Complete PCA output object from pca_analysis_enhanced() (optional)}

\item{plot_data}{Data.frame. Data containing PC coordinates and metadata variables}

\item{pca_result}{List. PCA result object (e.g., from prcomp() or princomp())}

\item{output_dir}{Character. Directory path for saving plots (default: NULL, no files saved)}

\item{processing_result}{List. Result object from process_mea_flexible() (optional)}

\item{experiment_name}{Character. Name for the experiment (used in titles and filenames)}

\item{grouping_variables}{Character vector. Available metadata variables for plotting (default: c("Treatment", "Genotype", "Timepoint"))}

\item{color_variable}{Character. Variable name for color aesthetic (default: "Treatment")}

\item{shape_variable}{Character. Variable name for shape aesthetic (default: "Genotype")}

\item{secondary_shape_variable}{Character. Alternative shape variable (default: "Timepoint")}

\item{pannels_var}{Character. Variable for panel faceting (default: NULL)}

\item{components}{Numeric vector. PC components to plot (default: c(1, 2))}

\item{gray_color_value}{Character. Specific value of color_variable to display in gray (default: NULL)}

\item{save_plots}{Logical. Whether to save plots to files (default: FALSE)}

\item{plot_width}{Numeric. Plot width in inches (default: 12)}

\item{plot_height}{Numeric. Plot height in inches (default: 10)}

\item{dpi}{Numeric. Plot resolution (default: 300)}

\item{verbose}{Logical. Whether to print progress messages (default: TRUE)}
}
\value{
A list containing:
\describe{
  \item{plots}{Named list of ggplot objects for each plot type}
  \item{plot_data}{Data.frame with plotting data and metadata}
  \item{variance_explained}{Numeric vector of variance explained by each component}
  \item{components_plotted}{Numeric vector of components used in plots}
  \item{color_palette}{Named character vector of colors used}
  \item{shape_palette}{Named numeric vector of shapes used}
  \item{plotting_config}{List of configuration parameters used}
  \item{saved_files}{Character vector of saved file paths (if save_plots = TRUE)}
}
}
\description{
Creates publication-ready PCA plots with scientific color palettes, flexible
aesthetic mapping, and multiple visualization options. Designed specifically
for neural activity and omics datasets with support for complex experimental
designs including treatments, genotypes, and timepoints.
}
\details{
The function creates up to 5 different plot variants. Files are only saved when
save_plots = TRUE AND output_dir is explicitly provided.
}
\seealso{
\code{\link{process_mea_flexible}} for MEA data processing,
\code{\link{discover_mea_structure}} for automatic data structure detection
}
