% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{aggregate_data}
\alias{aggregate_data}
\title{Aggregate Data by Groups}
\usage{
aggregate_data(data, group_col, variable_column, value_column, method)
}
\arguments{
\item{data}{Data frame to aggregate}

\item{group_col}{Column name for grouping}

\item{variable_column}{Column name containing variable identifiers}

\item{value_column}{Column name containing values to aggregate}

\item{method}{Aggregation method: "mean", "median", "sum"}
}
\value{
Aggregated data frame
}
\description{
Aggregates values within groups using specified method
}
\examples{
test_data <- data.frame(
  Group = rep(c("A", "B"), each = 10),
  Variable = rep(paste0("V", 1:5), 4),
  Value = rnorm(20)
)
agg <- aggregate_data(test_data, "Group", "Variable", "Value", "mean")

}
