% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo_correlation.R
\name{phylo_correlation}
\alias{phylo_correlation}
\title{Phylogenetically Corrected Correlation Analysis}
\usage{
phylo_correlation(traits_matrix, phylo_tree, method = "pearson")
}
\arguments{
\item{traits_matrix}{A numeric matrix or data frame where rows represent species
and columns represent traits. Row names should contain species names that
match the tip labels in the phylogenetic tree.}

\item{phylo_tree}{A phylogenetic tree object of class "phylo" (from the ape package).
The tree should contain the same species as in the traits matrix.}

\item{method}{Character string specifying the correlation method to use.
Options are "pearson" (default) or "spearman".}
}
\value{
A list containing two matrices:
\item{r}{A symmetric correlation matrix with phylogenetically corrected
correlation coefficients}
\item{P}{A symmetric matrix of p-values corresponding to the correlation tests}
}
\description{
This function calculates phylogenetically independent correlations between traits
using phylogenetic independent contrasts (PICs). It accounts for phylogenetic
relationships when computing correlations, which is important when analyzing
trait data from related species.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks if the phylogenetic tree is binary and converts it if necessary
\item Matches species between the trait matrix and phylogenetic tree
\item For each pair of traits, calculates phylogenetic independent contrasts (PICs)
\item Computes correlations between PICs instead of raw trait values
\item Handles missing data by using only complete cases for each trait pair
}

The phylogenetic independent contrasts method removes the effects of phylogenetic
relatedness, allowing for proper statistical inference about trait correlations.
This is crucial when analyzing data from related species, as standard correlation
methods may be biased due to phylogenetic non-independence.
}
\note{
\itemize{
\item The function requires at least 3 species with complete data for each trait pair
\item Non-binary trees are automatically converted to binary using \code{multi2di()}
\item Species present in the tree but missing from the trait matrix will generate warnings
\item The function handles missing values by performing pairwise complete case analysis
}
}
\examples{
data(PFF)
data(PFF_tree)
rownames(PFF) <- PFF$species
traits <- PFF[,4:21]
head(traits)
phylo_correlation(traits, PFF_tree, method = "pearson")

}
\references{
Felsenstein, J. (1985). Phylogenies and the comparative method. The American Naturalist, 125(1), 1-15.

Harvey, P. H., & Pagel, M. D. (1991). The comparative method in evolutionary biology. Oxford University Press.
}
