% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotScatter.R
\name{PlotScatter}
\alias{PlotScatter}
\title{PlotScatter}
\usage{
PlotScatter(MiRNA_CRData,status.0='Alive',status.1='Dead',
TitleYlab_A='Risk Score',TitleYlab_B='Survival Time',TitleXlab='Rank',
TitleLegend_A='Risk Group',TitleLegend_B='Status',
color.A=c(low='blue',high='red'),color.B=c(status.0='blue',status.1='red'))
}
\arguments{
\item{MiRNA_CRData}{A list includes a data frame with seven parts those are "sample", "status", "time", "target genes expression", "risk score", "group", and a data frame with five columns those are "Gene", "HR", "HR.95L", "HR.95H", "beta", and "P-value".}

\item{status.0}{string. Code for event 0. Default is 'Alive'}

\item{status.1}{string. Code for event 1. Default is 'Dead'}

\item{TitleYlab_A}{string, y-lab title for figure A. Default is 'Riskscore'}

\item{TitleYlab_B}{string, y-lab title for figure B. Default is 'Survival Time'}

\item{TitleXlab}{string, x-lab title for figure B. Default is 'Rank'}

\item{TitleLegend_A}{string, legend title for figure A. Default is 'Risk Group'}

\item{TitleLegend_B}{string, legend title for figure B. Default is 'Status'}

\item{color.A}{color for figure A. Default is low = 'blue', high = 'red'}

\item{color.B}{color for figure B. Default is status.0 = 'blue', status.1 = 'red'}
}
\value{
A riskscore picture
}
\description{
Function "PlotScatter" is used to plot a scatter diagram.
}
\examples{
# Obtain the example data
GEP<-GetData_Mirna("GEP")
survival<-GetData_Mirna("survival")
MiRNAs<-c("hsa-miR-21-5p","hsa-miR-26a-5p","hsa-miR-369-5p","hsa-miR-1238-3p","hsa-miR-10b-5p")
# Run the function
SingleMiRNA_CRData<-SingleMiRNA_CRModel(GEP,
"hsa-miR-21-5p",survival,cutoff.point=NULL)
PlotScatter(SingleMiRNA_CRData)
MutiMiRNA_CRData<-MutiMiRNA_CRModel(GEP,
MiRNAs,survival,cutoff.point=NULL)
PlotScatter(MutiMiRNA_CRData)
}
