% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beta_correction_plot_functions.R
\name{beta_corrected_density}
\alias{beta_corrected_density}
\title{Density Plot of Beta Corrections for a Variable}
\usage{
beta_corrected_density(varname, q = 0.05, type = "kde")
}
\arguments{
\item{varname}{Character string specifying the variable name OR coefficient name is accepted as well.}

\item{q}{Number, must be between 0 and 0.5. Determines the quantile range of the plot (i.e. value of 0.05 will only show shaps within 5pct --> 95pct quantile range for plot)}

\item{type}{Character string, must be "kde" or "hist"}
}
\value{
ggplot object(s) showing the density distribution of corrected beta coefficients
with vertical lines indicating the original coefficient value and standard error bounds.

The item returned will be:
\itemize{
  \item single ggplot object when `varname` was a numerical variable OR a coefficient name
  \item list of ggplot objects when `varname` was a categorical variable
}
}
\description{
Generates a density plot showing the distribution of corrected Beta values
to a GLM coefficient, along with the original Beta coefficient, and standard error bounds around it.

\strong{NOTE} This function signature documents the interface of functions created by \code{\link{create_beta_corrected_density}}.
}
\details{
The plot shows:
\itemize{
  \item Density curve of corrected coefficient values
  \item Solid vertical line at the original GLM coefficient
  \item Dashed lines at plus/minus 1 standard error from the coefficient
  \item Automatic x-axis limits that cut off the highest and lowest q pct. If you want axis unaltered, set q = 0
}
}
\examples{
# This function is created inside explain_iblm() and is output as an item

df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

explain_objects <- explain_iblm(iblm_model, df_list$test)

# plot can be for a single categorical level OR a categorical variable
explain_objects$beta_corrected_density(varname = "AreaB")

# output can be numerical variable
explain_objects$beta_corrected_density(varname = "DrivAge")


# This function must be created, and cannot be called directly from the package
try(
beta_corrected_density(varname = "DrivAge")
)
}
\seealso{
\code{\link{create_beta_corrected_density}}, \code{\link{explain_iblm}}
}
