% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_theorem.R
\name{g_theorem}
\alias{g_theorem}
\title{Simulation wrapper for Theorems 9 & 10}
\usage{
g_theorem(n, p, m, g_type, epsilon, zero_tol = 0.02)
}
\arguments{
\item{n}{sample size}

\item{p}{number of observed variables}

\item{m}{number of latent factors}

\item{g_type}{character: "linear", "weak_nonlinear", "strong_nonlinear"}

\item{epsilon}{error threshold}

\item{zero_tol}{zero-mean tolerance (default 0.02)}
}
\value{
one-row data-frame
}
\description{
One Monte-Carlo replicate; returns empirical error, exceedance indicator,
theoretical bounds, and assumption-check flags.
}
\examples{
  df <- g_theorem(500, 200, 5, "linear", 0.6)
}
