% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_ger_nfi_2012.R
\name{validate_fe_species_ger_nfi_2012}
\alias{validate_fe_species_ger_nfi_2012}
\title{Validate an \emph{fe_species_ger_nfi_2012} Object}
\usage{
validate_fe_species_ger_nfi_2012(x = character())
}
\arguments{
\item{x}{An object that is expected to be a correct
\code{fe_species_ger_nfi_2012} object}
}
\value{
Returns \code{x}, but this function is mainly called for its side
effect which is pointing out any violations of the
\code{fe_species_ger_nfi_2012} object specifications. In case of such
violations, the function will terminate with an error.
}
\description{
Regular users will not require this function. Expert users will want to use
it in combination with the constructor
\code{\link{new_fe_species_ger_nfi_2012}}. Regular users, please construct
\code{fe_species_ger_nfi_2012} objects with
\code{\link{fe_species_ger_nfi_2012}}.
}
\examples{
# Passes validation
spec_ids <- as.character(c(30, 30, 30, 10, 10, 10, 10, 20, 20, 290))
spec_ids <- new_fe_species_ger_nfi_2012(spec_ids)
validate_fe_species_ger_nfi_2012(spec_ids)

# Validating the following spec_ids throws an error due to
# non-supported species codes
spec_ids <- as.character(c(30, 30, 542, 10, 10, 10, 1234, 20, 20, 290))
spec_ids <- new_fe_species_ger_nfi_2012(spec_ids)
try(
  validate_fe_species_ger_nfi_2012(spec_ids)
)

}
