% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FoRDM.R
\name{fordm_analysis_satisficing}
\alias{fordm_analysis_satisficing}
\title{FoRDM Satisficing-Based many-objective Robust Decision-Making Analysis}
\usage{
fordm_analysis_satisficing(fordm_table, objectives, robustness = 0.9)
}
\arguments{
\item{fordm_table}{Output from build_fordm_table().}

\item{objectives}{Output from build_objectives_satisficing().}

\item{robustness}{Numeric (0-1) specifying the robustness level across SOWs, e.g., 0.9 evaluates management performance that meets objectives in at least 90\% of SOWs.}
}
\value{
A list containing the FoRDM analysis results:
\itemize{
\item \code{optimal}: The management strategy that balances all objectives (Euclidean distance) while meeting the robustness threshold.
\item \code{pareto_front}: The Pareto front of robust management strategies.
}
}
\description{
Performs a satisficing-based many-objective robustness analysis for the provided data and objectives, providing a optimal robust management and the Pareto front.
}
