% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FoRDM.R
\name{fordm_analysis_regret}
\alias{fordm_analysis_regret}
\title{FoRDM Regret-Based many-objective Robust Decision-Making Analysis}
\usage{
fordm_analysis_regret(
  fordm_table,
  objectives,
  robustness = 0.9,
  method = "regretII"
)
}
\arguments{
\item{fordm_table}{Output from build_fordm_table().}

\item{objectives}{Output from build_objectives_regret().}

\item{robustness}{Numeric (0-1) specifying the quantile of regret used to define robustness, e.g., 0.9 evaluates management performance that is at least as good as in 90\% of SOWs.}

\item{method}{the method used to evaluate robustness
\itemize{
\item \code{"regretII"}: Regret type II (regret to best performing alternative) approach using the robustness quantile of scenario regrets.
\item \code{"CVaR"}: Conditional Value at Risk, using the mean of the worst (1 - robustness) fraction of weighted regrets for risk-aware selection.
}}
}
\value{
A list containing the results of the FoRDM analysis:
\itemize{
\item \code{optimal}: The management strategy identified as most robust given the regret metrics.
\item \code{pareto_front}: The Pareto front of robust management strategies.
}
}
\description{
Performs a regret-based (Type II or cVaR) many-objective robustness analysis for the provided data and objectives, providing a optimal robust management and the Pareto front.
}
