% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp_solver.R
\name{ot_test_lp_solver}
\alias{ot_test_lp_solver}
\title{Control \code{FDOTT} linear programming solver}
\usage{
ot_test_lp_solver(name = NULL, ...)
}
\arguments{
\item{name}{name of the LP solver.}

\item{...}{optional control arguments passed to the corresponding LP solver.}
}
\value{
A \code{ot_test_lp_solver_control} object containing:
\tabular{ll}{
\code{name}     \tab the name of the LP solver \cr
\code{control}   \tab list of control arguments passed to the LP solver \cr
}
}
\description{
Create an object that controls the linear programming (LP) solver to use.
}
\details{
\code{name} can be any LP solver that is compatible with the \code{ROI} package infrastructure.
In particular, the corresponding plugin package \code{ROI.plugin.name} must be installed.
The default value corresponding to \code{name = NULL} can be set via \code{options(FDOTT.lp_solver = name)}
(the default is \code{"glpk"}).
}
\examples{
\dontrun{
# glpk is already the default
options(FDOTT.lp_solver = "glpk")}
# plugin needs to be installed, else we get error
if (requireNamespace("ROI.plugin.glpk")) {
    # add control parameter (specific to glpk)
    sol <- ot_test_lp_solver("glpk", verbose = TRUE)
    print(sol)
} else {
    cat("'ROI.plugin.glpk' needs to be installed!\n")
}
}
\seealso{
\code{\link[ROI:ROI_available_solvers]{ROI::ROI_available_solvers}}
}
