% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpf.evaluate.core.R
\name{vpf.evaluate.core}
\alias{vpf.evaluate.core}
\title{Variance of Phenotypic Frequency}
\usage{
vpf.evaluate.core(data, names, qualitative, selected, na.omit = TRUE)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{na.omit}{logical. If \code{TRUE}, missing values (\code{NA}) are
ignored and not included as a distinct factor level for analysis. Default
is \code{TRUE}.}
}
\value{
The Variance of Phenotypic Frequency values for EC and CS.
}
\description{
Compute the Variance of Phenotypic Frequency (\mjseqn{VPF})
\insertCite{li_studies_2002}{EvaluateCore} to compare qualitative traits
between entire collection (EC) and core set (CS).
}
\details{
Variance of Phenotypic Frequency (\mjseqn{VPF})
\insertCite{li_studies_2002}{EvaluateCore} is computed as follows.

\mjsdeqn{VPF = \frac{1}{n} \sum_{i=1}^{n}\left ( \frac{\sum_{j=1}^{k} (p_{ij}
- \overline{p_{i}})^{2}}{k - 1} \right )}

Where, \mjseqn{p_{ij}} denotes the proportion/fraction/frequency of
accessions in the \mjseqn{i}th phenotypic class for the \mjseqn{i}th trait,
\mjseqn{\overline{p_{i}}} is the mean frequency of phenotypic classes for the
\mjseqn{i}th trait, \mjseqn{k} is the number of phenotypic classes for the
\mjseqn{i}th trait and \mjseqn{n} is the total number of traits.
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

vpf.evaluate.core(data = ec, names = "genotypes",
                  qualitative = qual, selected = core)

}
\references{
\insertAllCited{}
}
