% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_ts_design.R
\name{get_initial_estimates}
\alias{get_initial_estimates}
\title{Get initial parameter estimates for time series models}
\usage{
get_initial_estimates(
  model_params,
  initial = NULL,
  method = "pmm2",
  verbose = FALSE
)
}
\arguments{
\item{model_params}{Validated model parameters from validate_ts_parameters}

\item{initial}{Optionally user-provided initial estimates}

\item{method}{Estimation method}

\item{verbose}{Output detailed information}
}
\value{
List containing:
\item{b_init}{Vector of initial AR/MA coefficients}
\item{x_mean}{Estimated mean (if include.mean=TRUE)}
\item{innovations}{Initial residuals/innovations}
\item{x_centered}{Centered (or differenced + centered) series}
\item{m2}{Second central moment of initial residuals}
\item{m3}{Third central moment of initial residuals}
\item{m4}{Fourth central moment of initial residuals}
}
\description{
Get initial parameter estimates for time series models
}
\keyword{internal}
