% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_unit.r
\name{as_unit_ecotox}
\alias{as_unit_ecotox}
\title{Text from the ECOTOX database to \code{mixed_units}}
\usage{
as_unit_ecotox(
  x,
  type = c("concentration", "duration", "length", "media", "application", "size",
    "weight", "unknown"),
  ...,
  warn = TRUE
)
}
\arguments{
\item{x}{A vector of \code{character} strings. It expects fields as commonly returned
from the ECOTOX database.}

\item{type}{The type of unit that can help the sanitation process. See the 'usage'
section for available options. These options are linked to the different unit tables
in the database (see \code{vignette("ecotox-schema")}). It can help to interpret ambiguous
units correctly. For instance, 'dpm' can both mean 'disintegrations per minute'
(\code{type = "concentration"}) and 'days post-moult' (\code{type = "duration"}).}

\item{...}{Ignored.}

\item{warn}{If set to \code{FALSE} warnings while converting text to units are suppressed.}
}
\value{
A vector of \code{?units::unit} class objects with the same length as \code{x}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Convert text to units after
sanitising.
}
\details{
The following steps are performed (in the order as listed)
to sanitise text before coercing it to units:
\itemize{
\item The following is removed:
\itemize{
\item Leading/trailing white spaces
\item Square brackets and commas
\item A list of common prefixes
\item Double spaces are replaced by single spaces
\item Brackets around multiply symbol
}
\item The following is corrected/adjusted:
\itemize{
\item 'for' is interpreted as multiplication
\item Scientific notation of numbers is
standardised where possible.
\item A list of ambiguous patterns is replaced with
more explicit strings. For instance,
'deg' is replaced with 'degree'.
}
\item The following miscellaneous corrections are made:
\itemize{
\item A list of 'known' annotations are removed from the units
\item A list of elements kown to represent counts are renamed
'counts'.
\item Percentages are renamed as explicit concentration in
mass per volume or volume per volume units where possible
\item 'CI' is renamed 'Curies'.
\item 'M' is renamed 'mol/L'.
\item Units expressed as 'parts per ...' are explicitly renamed
to mass over volume, or volum over volume where possible
}
\item Type specific sanitation steps
\itemize{
\item Concentration units:
\itemize{
\item 'K' is renamed 'Karmen'
\item 'dpm' is renamed 'counts/min' (i.e., disintegrations per minute)
}
\item Media units:
\itemize{
\item 'K' is renamed 'Kelvin'
\item 'C' is renamed 'Celsius'
}
}
\item Some final miscellaneous adjustments:
\itemize{
\item Scientific notation in numbers is not supported by the units package.
Numbers are formatted in decimal notation where possible.
\item Spaces are removed if preceded by numeric and followed by
alphabetical character
\item All equivalents of ambiguous synonyms for time units are explicitly
renamed to their respective unit (e.g., 'dph' (days post hatching) -> 'day')
\item unreported/missing units are renamed 'unit'
}
}

It is your own responsibility to check if the sanitising steps are appropriate for
your analyses.
}
\examples{
## Try parsing a random set of units from the database:
c("ppm-d", "ml/2.5 cm eu", "fl oz/10 gal/1k sqft", "kg/100 L",
  "mopm", "ng/kg", "ug", "AI ng/g", "PH", "pm", "uM/cm3", "1e-4 mM",
  "degree", "fs", "mg/TI", "RR", "ug/g org/d", "1e+4 IU/TI", "pg/mg TE",
  "pmol/mg", "1e-9/l", "no >15 cm", "umol/mg pro", "cc/org/wk", "PIg/L",
  "ug/100 ul/org", "ae mg/kg diet/d", "umol/mg/h", "cmol/kg d soil",
  "ug/L diet", "kg/100 kg sd", "1e+6 cells", "ul diet", "S", "mmol/h/g TI",
  "g/70 d", "vg", "ng/200 mg diet", "uS/cm2", "AI ml/ha", "AI pt/acre",
  "mg P/h/g TI", "no/m", "kg/ton sd", "ug/g wet wt", "AI mg/2 L diet",
  "nmol/TI", "umol/g wet wt", "PSU", "Wijs number") |>
  as_unit_ecotox(warn = FALSE)

## Adding the type of measurement can affect interpretation:
as_unit_ecotox(c("C", "K"), type = "concentration")
as_unit_ecotox(c("C", "K"), type = "media")
}
\seealso{
Other ecotox-sanitisers: 
\code{\link{as_date_ecotox}()},
\code{\link{as_numeric_ecotox}()},
\code{\link{mixed_to_single_unit}()},
\code{\link{process_ecotox_dates}()},
\code{\link{process_ecotox_numerics}()},
\code{\link{process_ecotox_units}()}
}
\author{
Pepijn de Vries
}
\concept{ecotox-sanitisers}
