% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{find_optimal_threshold_dia}
\alias{find_optimal_threshold_dia}
\title{Find Optimal Probability Threshold}
\usage{
find_optimal_threshold_dia(
  prob_positive,
  y_true,
  type = c("f1", "youden"),
  pos_class,
  neg_class
)
}
\arguments{
\item{prob_positive}{A numeric vector of predicted probabilities for the
positive class.}

\item{y_true}{A factor vector of true class labels.}

\item{type}{A character string, specifying the optimization criterion:
"f1" for F1-score or "youden" for Youden's J statistic (Sensitivity + Specificity - 1).}

\item{pos_class}{A character string, the label for the positive class.}

\item{neg_class}{A character string, the label for the negative class.}
}
\value{
A numeric value, the optimal probability threshold.
}
\description{
Determines an optimal probability threshold for binary
classification based on maximizing F1-score or Youden's J statistic.
}
\examples{
y_true_ex <- factor(c("Negative", "Positive", "Positive", "Negative", "Positive"),
                    levels = c("Negative", "Positive"))
prob_ex <- c(0.1, 0.8, 0.6, 0.3, 0.9)

# Find threshold maximizing F1-score
opt_f1_threshold <- find_optimal_threshold_dia(
  prob_positive = prob_ex,
  y_true = y_true_ex,
  type = "f1",
  pos_class = "Positive",
  neg_class = "Negative"
)
print(opt_f1_threshold)

# Find threshold maximizing Youden's J
opt_youden_threshold <- find_optimal_threshold_dia(
  prob_positive = prob_ex,
  y_true = y_true_ex,
  type = "youden",
  pos_class = "Positive",
  neg_class = "Negative"
)
print(opt_youden_threshold)
}
