% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSPC.R
\name{DSPC}
\alias{DSPC}
\title{Distributed Sparse Principal Component Analysis}
\usage{
DSPC(data, m, gamma, n1, K)
}
\arguments{
\item{data}{A numeric matrix containing the total dataset.}

\item{m}{An integer specifying the number of principal components.}

\item{gamma}{A numeric value specifying the sparsity parameter for SPC.}

\item{n1}{An integer specifying the length of each data subset.}

\item{K}{An integer specifying the number of nodes.}
}
\value{
A list with the following components:
\describe{
  \item{Aspro}{List of sparse loading matrices for each node.}
  \item{Dspro}{List of diagonal residual variance matrices for each node.}
  \item{Sigmahatpro}{List of covariance matrices for each node.}
}
}
\description{
Performs distributed sparse principal component analysis (DSPC)
on a numeric dataset split across multiple nodes. Estimates sparse loading matrices,
residual variances, and covariance matrices for each node.
}
\examples{
set.seed(123)
data <- matrix(rnorm(500), nrow = 100, ncol = 5)
DSPC(data = data, m = 3, gamma = 0.03, n1 = 20, K = 5)
}
