% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp2Scale.R
\name{dmnorm_gp2Scale}
\alias{dmnorm_gp2Scale}
\title{Function for the evaluating the Gaussian likelihood with gp2Scale sparse covariance.}
\usage{
dmnorm_gp2Scale(x, mean, Cov, N, Nnz, log = 1)
}
\arguments{
\item{x}{Vector of measurements}

\item{mean}{Vector of mean values}

\item{Cov}{Matrix of size N x N; sparse kernel}

\item{N}{Number of measurements in x}

\item{Nnz}{Number of measurements in x}

\item{log}{Logical; should the density be evaluated on the log scale.}
}
\value{
Returns the Gaussian likelihood using the gp2Scale sparse covariance.
}
\description{
\code{dmnorm_gp2Scale} (and \code{rmnorm_gp2Scale}) calculate the usual Gaussian
likelihood for a fixed set of parameters (but with sparse matrices). Finally,
the distributions must be registered within \code{nimble}.
}
