% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint-method.R
\name{confint,bsw-method}
\alias{confint,bsw-method}
\title{Estimating confidence intervals of the estimated model parameters of \code{bsw()}}
\usage{
\S4method{confint}{bsw}(object, parm, level = 0.95, method = "wald", R = 1000L)
}
\arguments{
\item{object}{An object of class \code{"bsw"}.}

\item{parm}{A specification of which model parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all model parameters are considered.}

\item{level}{A numeric value that indicates the level of confidence.}

\item{method}{A character giving the estimation method of the confidence intervals (\code{"bca"} or \code{"wald"}).}

\item{R}{A positive integer giving the number of bootstrap replicates.}
}
\value{
A matrix with columns giving the lower and upper confidence limits of each estimated model parameter.
}
\description{
For objects of class \code{"bsw"}, \code{confint()} estimates confidence intervals of the estimated model parameters of \code{bsw()}.
}
\details{
\code{confint} provides Wald (default) and bias-corrected accelerated bootstrap confidence intervals of the estimated model parameters of \code{bsw()}.
}
\author{
Adam Bekhit, Jakob Schöpe
}
