% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/command.R
\name{system3}
\alias{system3}
\title{Run \code{system2()} and mark its character output as UTF-8 if appropriate}
\usage{
system3(...)
}
\arguments{
\item{...}{Passed to \code{\link[=system2]{system2()}}.}
}
\value{
The value returned by \code{system2()}.
}
\description{
This is a wrapper function based on \code{system2()}. If \code{system2()}
returns character output (e.g., with the argument \code{stdout = TRUE}),
check if the output is encoded in UTF-8. If it is, mark it with UTF-8
explicitly.
}
\examples{\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
a = shQuote(c("-e", "print(intToUtf8(c(20320, 22909)))"))
x2 = system2("Rscript", a, stdout = TRUE)
Encoding(x2)  # unknown

x3 = xfun::system3("Rscript", a, stdout = TRUE)
# encoding of x3 should be UTF-8 if the current locale is UTF-8
!l10n_info()[["UTF-8"]] || Encoding(x3) == "UTF-8"  # should be TRUE
\dontshow{\}) # examplesIf}
}
