% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_search.R
\name{random_search_single}
\alias{random_search_single}
\title{Randomize the location of a single turbine}
\usage{
random_search_single(result, Polygon1, n = 20, Plot = FALSE, max_dist = 2.2)
}
\arguments{
\item{result}{The resulting matrix of the function \code{\link{genetic_algorithm}}}

\item{Polygon1}{The considered area as SpatialPolygon, SimpleFeature Polygon
or coordinates as matrix/data.frame}

\item{n}{The number of random searches to be performed. Default is 20.}

\item{Plot}{Should the random search be plotted? Default is \code{FALSE}}

\item{max_dist}{A numeric value multiplied by the rotor radius to perform
collision checks. Default is 2.2}
}
\value{
Returns a list
}
\description{
Perform a random search for a single turbine, to further
optimize the output of the wind farm layout.
}
\seealso{
Other Randomization: 
\code{\link{plot_random_search}()},
\code{\link{random_search}()}

Other Plotting Functions: 
\code{\link{plot_cloud}()},
\code{\link{plot_development}()},
\code{\link{plot_evolution}()},
\code{\link{plot_fitness_evolution}()},
\code{\link{plot_parkfitness}()},
\code{\link{plot_result}()},
\code{\link{plot_windfarmGA}()},
\code{\link{plot_windrose}()}
}
\concept{Plotting Functions}
\concept{Randomization}
