% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thermalTime.R
\name{thermalTimeDaily}
\alias{thermalTimeDaily}
\title{Calculate thermal time using cardinal temperatures}
\usage{
thermalTimeDaily(mint, maxt, x_temp, y_temp, method = NULL)
}
\arguments{
\item{mint}{The minimum temperature}

\item{maxt}{The maximum temperature}

\item{x_temp}{The cardinal temperatures}

\item{y_temp}{The effective thermal time}

\item{method}{The method to calculate thermal time. 
The default method is ( maxt + mint ) / 2 - base. 
The three hour temperature methods will be usesd if method = '3hr'}
}
\value{
The thermal time.
}
\description{
Calculate thermal time using cardinal temperatures
}
\examples{
mint <- c(0, 10)
maxt <- c(30, 40)
x_temp <- c(0, 20, 35)
y_temp <- c(0, 20, 0)
thermalTimeDaily(mint, maxt, x_temp, y_temp)
thermalTimeDaily(mint, maxt, x_temp, y_temp, method = '3hr')
}
