% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waiter.R
\name{triggerWaiter}
\alias{triggerWaiter}
\title{Trigger Waiter}
\usage{
triggerWaiter(
  el,
  id = NULL,
  html = NULL,
  color = NULL,
  image = "",
  fadeout = FALSE,
  on = "click",
  hide_on_render = !is.null(id),
  hide_on_error = !is.null(id),
  hide_on_silent_error = !is.null(id)
)
}
\arguments{
\item{el}{Element that triggers the waiter.}

\item{id}{Id of element to hide or element on which to show waiter over.}

\item{html}{HTML content of waiter, generally a spinner, see \code{\link{spinners}}.}

\item{color}{Background color of loading screen.}

\item{image}{Path to background image.}

\item{fadeout}{Use a fade out effect when the screen is removed.
Can be a boolean, or a numeric indicating the number of
milliseconds the effect should take.}

\item{on}{The event that triggers the waiter.}

\item{hide_on_render}{Set to \code{TRUE} to automatically hide the waiter
when the plot in \code{id} is drawn. Note the latter will only work with
shiny plots, tables, htmlwidgets, etc. but will not work with arbitrary
elements.}

\item{hide_on_error, hide_on_silent_error}{Whether to hide the waiter when the underlying element throws an error.
Silent error are thrown by \link[shiny]{req} and  \link[shiny]{validate}.}
}
\description{
A a trigger to a waiting screen from the UI.
}
\examples{
library(shiny)
library(waiter)

ui <- fluidPage(
 useWaiter(),
 triggerWaiter(
   actionButton(
     "generate",
     "Generate Plot"
   )
 ),
 plotOutput("plot")
)

server <- function(input, output){
 output$plot <- renderPlot({
   input$generate
   Sys.sleep(3)
   plot(runif(50))
 })
}

if(interactive())
 shinyApp(ui, server)

}
