% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LC.R
\name{LC}
\alias{LC}
\alias{report.LC}
\title{Lee-Carter model}
\usage{
LC(
  formula,
  adjust = c("dt", "dxt", "e0", "none"),
  jump_choice = c("fit", "actual"),
  scale = FALSE,
  ...
)
}
\arguments{
\item{formula}{Model specification. It should include the log of the variable to be modelled.
See the examples.}

\item{adjust}{method to use for adjustment of coefficients \eqn{k_t}.
Possibilities are
\code{"dt"} (Lee-Carter method, the default),
\code{"dxt"} (BMS method),
\code{"e0"} (Lee-Miller method based on life expectancy) and
\code{"none"}.}

\item{jump_choice}{Method used for computation of jump-off point for forecasts.
Possibilities: \code{"actual"} (use actual rates from final year) and
\code{"fit"} (use fitted rates).
The original Lee-Carter method used \code{"fit"} (the default), but Lee and Miller (2001)
and most other authors prefer \code{"actual"}.}

\item{scale}{If TRUE, \code{bx} and \code{kt} are rescaled so that \code{kt} has drift parameter = 1.}

\item{...}{Not used.}
}
\value{
A model specification.
}
\description{
Lee-Carter model of mortality or fertility rates.
\code{LC()} returns a Lee-Carter model applied to the formula's response
variable as a function of age. This produces a standard Lee-Carter model by
default, although many other options are available. Missing rates are set to
the geometric mean rate for the relevant age.
}
\examples{
lc <- norway_mortality |>
  dplyr::filter(Sex == "Female") |>
  model(lee_carter = LC(log(Mortality)))
report(lc)
autoplot(lc)
}
\references{
Basellini, U, Camarda, C G, and Booth, H (2022) Thirty years on:
A review of the Lee-Carter method for forecasting mortality.
\emph{International Journal of Forecasting}, 39(3), 1033-1049.

Booth, H., Maindonald, J., and Smith, L. (2002) Applying Lee-Carter
under conditions of variable mortality decline. \emph{Population Studies},
\strong{56}, 325-336.

Lee, R D, and Carter, L R (1992) Modeling and forecasting US mortality.
\emph{Journal of the American Statistical Association}, 87, 659-671.

Lee R D, and Miller T (2001). Evaluating the performance of the Lee-Carter
method for forecasting mortality. \emph{Demography}, 38(4), 537–549.
}
\seealso{
\code{\link[=LC2]{LC2()}}, \code{\link[=FDM]{FDM()}}
}
\author{
Rob J Hyndman
}
