% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/udpipe_models.R
\name{udpipe_load_model}
\alias{udpipe_load_model}
\title{Load an UDPipe model}
\usage{
udpipe_load_model(file)
}
\arguments{
\item{file}{full path to the model or the value returned by a call to \code{\link{udpipe_download_model}}}
}
\value{
An object of class \code{udpipe_model} which is a list with 2 elements
\itemize{
 \item file: The path to the model as provided by \code{file}
 \item model: An Rcpp-generated pointer to the loaded model which can be used in \code{\link{udpipe_annotate}}
}
}
\description{
Load an UDPipe model so that it can be use in \code{\link{udpipe_annotate}}
}
\examples{
\dontrun{
x <- udpipe_download_model(language = "dutch-lassysmall")
x$file_model
ud_english <- udpipe_load_model(x$file_model)

x <- udpipe_download_model(language = "english")
x$file_model
ud_english <- udpipe_load_model(x$file_model)

x <- udpipe_download_model(language = "hebrew")
x$file_model
ud_hebrew <- udpipe_load_model(x$file_model)
}


x <- udpipe_download_model(language = "dutch-lassysmall", model_dir = tempdir())
x$file_model
if(!x$download_failed){
  ud_dutch <- udpipe_load_model(x$file_model)
}

## cleanup for CRAN
if(file.exists(x$file_model)) file.remove(x$file_model)
}
\references{
\url{https://ufal.mff.cuni.cz/udpipe}
}
\seealso{
\code{\link{udpipe_annotate}}, \code{\link{udpipe_download_model}}, \code{\link{udpipe_train}}
}
