% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_aug_awareness.R
\name{ts_aug_awareness}
\alias{ts_aug_awareness}
\title{Augmentation by awareness}
\usage{
ts_aug_awareness(factor = 1)
}
\arguments{
\item{factor}{increase factor for data augmentation}
}
\value{
a \code{ts_aug_awareness} object.
}
\description{
Time series data augmentation is a technique used to increase the size and diversity of a time series dataset by creating new instances of the original data through transformations or modifications. The goal is to improve the performance of machine learning models trained on time series data by reducing overfitting and improving generalization.
Awareness reinforce recent data preferably.
}
\examples{
library(daltoolbox)
data(tsd)

#convert to sliding windows
xw <- ts_data(tsd$y, 10)

#data augmentation using awareness
augment <- ts_aug_awareness()
augment <- fit(augment, xw)
xa <- transform(augment, xw)
ts_head(xa)
}
