% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_aum_loss}
\alias{nn_aum_loss}
\title{AUM loss}
\usage{
nn_aum_loss()
}
\description{
Creates a criterion that measures the Area under the \eqn{Min(FPR, FNR)} (AUM) between each
element in the input \eqn{pred_tensor} and target \eqn{label_tensor}.
}
\details{
This is used for measuring the error of a binary reconstruction within highly unbalanced dataset,
where the goal is optimizing the ROC curve. Note that the targets \eqn{label_tensor} should be factor
level of the binary outcome, i.e. with values \code{1L} and \code{2L}.
}
\examples{
if (torch_is_installed()) {
\dontshow{if (torch_is_installed()) withAutoprint(\{ # examplesIf}
loss <- nn_aum_loss()
input <- torch_randn(4, 6, requires_grad = TRUE)
target <- input > 1.5
output <- loss(input, target)
output$backward()
\dontshow{\}) # examplesIf}
}
}
\references{
J. Hillman, T.D. Hocking: Optimizing ROC Curves with a Sort-Based
Surrogate Loss for Binary Classification and Changepoint Detection
https://jmlr.org/papers/volume24/21-0751/21-0751.pdf
}
