% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_tt.R, R/zzz-aliases.R
\name{group_tt}
\alias{group_tt}
\alias{tt_group}
\title{Spanning labels to identify groups of rows or columns}
\usage{
group_tt(
  x,
  i = getOption("tinytable_group_i", default = NULL),
  j = getOption("tinytable_group_j", default = NULL),
  ...
)

tt_group(
  x,
  i = getOption("tinytable_group_i", default = NULL),
  j = getOption("tinytable_group_j", default = NULL),
  ...
)
}
\arguments{
\item{x}{A data frame or data table to be rendered as a table.}

\item{i}{Character vector, named list, or integer vector
\itemize{
\item A character vector of labels with length equal to the number of rows in \code{x}
\item A named list of row indices to group. The names of the list will be used as labels. The indices represent the position where labels should be inserted in the original table. For example,
\itemize{
\item \code{i=list("Hello"=5)}: insert the "Hello" label after the 4th row in the original table.
\item \code{i=list("Hello"=2, "World"=2)}: insert the two labels consecutively after the 1st row in the original table.
\item \code{i=list("Foo Bar"=0)}: insert the label in the first row after the header.
}
\item Vector of positive integers: For matrix insertion: \code{i} specifies row positions and \code{j} must be a character matrix to insert in the table (see below for details).
}}

\item{j}{String, named list, or character matrix
\itemize{
\item Named list of column indices to group, ex: \code{j=list("A"=1:2,"B"=3:6)}. The names of the list will be used as labels. See below for more examples. Note: empty labels must be a space: " ".
\item A single string when column names include the group name as a prefix, ex: group1_column1, group1_column2, etc.
\item Character matrix for inserting rows at positions specified by \code{i}. The matrix must have the same number of columns as the table, or be a single column with a number of elements that is a multiple of the table's column count (which will be automatically reshaped). Each row of the matrix matches an element
}}

\item{...}{Other arguments are ignored.}
}
\value{
An object of class \code{tt} representing the table.
}
\description{
Spanning labels to identify groups of rows or columns

Alias for \code{group_tt()}
}
\details{
Warning: The \code{style_tt()} can normally be used to style the group headers, as expected, but that feature is not available for Markdown and Word tables.
}
\section{Word and Markdown limitations}{


Markdown and Word tables only support these styles: italic, bold, strikeout. The \code{width} argument is also unavailable
Moreover, the \code{style_tt()} function cannot be used to style headers inserted by the \code{group_tt()} function;
instead, you should style the headers directly in the header definition using markdown syntax:
\code{group_tt(i = list("*italic header*" = 2))}. These limitations are due to the fact that there is no markdown
syntax for the other options, and that we create Word documents by converting a markdown table to .docx
via the Pandoc software.
}

\examples{

# vector of row labels
dat <- data.frame(
  label = c("a", "a", "a", "b", "b", "c", "a", "a"),
  x1 = rnorm(8),
  x2 = rnorm(8)
)
tt(dat[, 2:3]) |> group_tt(i = dat$label)

# named lists of labels
tt(mtcars[1:10, 1:5]) |>
  group_tt(
    i = list(
      "Hello" = 3,
      "World" = 8
    ),
    j = list(
      "Foo" = 2:3,
      "Bar" = 4:5
    )
  )

dat <- mtcars[1:9, 1:8]
tt(dat) |>
  group_tt(i = list(
    "I like (fake) hamburgers" = 3,
    "She prefers halloumi" = 4,
    "They love tofu" = 7
  ))

tt(dat) |>
  group_tt(
    j = list(
      "Hamburgers" = 1:3,
      "Halloumi" = 4:5,
      "Tofu" = 7
    )
  )

x <- mtcars[1:5, 1:6]
tt(x) |>
  group_tt(j = list("Hello" = 1:2, "World" = 3:4, "Hello" = 5:6)) |>
  group_tt(j = list("Foo" = 1:3, "Bar" = 4:6))

# column names with delimiters
dat <- data.frame(
  A_id = 1,
  A_a1 = 2,
  A_a2 = "3",
  B_b1 = 4,
  B_b2 = 5,
  B_C = 6
)
tt(dat) |> group_tt(j = "_")

# matrix insertion
rowmat <- matrix(colnames(iris))
tt(head(iris, 7)) |>
  group_tt(i = c(2, 5), j = rowmat)

rowmat <- matrix(c(
  "a", "b", "c", "d", "e",
  1, 2, 3, 4, 5))
tt(head(iris, 7)) |>
  group_tt(i = 2, j = rowmat) |>
  style_tt(i = "groupi", background = "pink")
}
