% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_is_regular.R
\name{time_is_regular}
\alias{time_is_regular}
\title{Is time a regular sequence? (Experimental)}
\usage{
time_is_regular(
  x,
  timespan = granularity(x),
  g = NULL,
  use.g.names = TRUE,
  na.rm = TRUE,
  allow_gaps = FALSE,
  allow_dups = FALSE
)
}
\arguments{
\item{x}{Time vector. \cr
E.g. a \code{Date}, \code{POSIXt}, \code{numeric} or any time-based vector.}

\item{timespan}{\link{timespan}.}

\item{g}{Grouping object passed directly to \code{collapse::GRP()}.
This can for example be a vector or data frame. \cr
Note that when \code{g} is supplied the output is a logical with length
matching the number of unique groups.}

\item{use.g.names}{Should the result include group names?
Default is \code{TRUE}.}

\item{na.rm}{Should \code{NA} values be removed before calculation?
Default is \code{TRUE}.}

\item{allow_gaps}{Should gaps be allowed? Default is \code{FALSE}.}

\item{allow_dups}{Should duplicates be allowed? Default is \code{FALSE}.}
}
\value{
A logical vector the same length as the number of supplied groups.
}
\description{
This function is a fast way to check if a time vector
is a regular sequence, possibly for many groups.
Regular in this context means that the lagged time differences are a
whole multiple of the specified time unit. \cr
This means \code{x} can be a regular sequence with or without gaps in time.
}
\examples{
library(timeplyr)
library(lubridate)
library(dplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 1L)
collapse::set_collapse(nthreads = 1L)
}
x <- 1:5
y <- c(1, 1, 2, 3, 5)

# No duplicates or gaps allowed by default
time_is_regular(x)
time_is_regular(y)

increment <- 1

# duplicates and gaps allowed
time_is_regular(x, increment, allow_dups = TRUE, allow_gaps = TRUE)
time_is_regular(y, increment, allow_dups = TRUE, allow_gaps = TRUE)

# No gaps allowed
time_is_regular(x, increment, allow_dups = TRUE, allow_gaps = FALSE)
time_is_regular(y, increment, allow_dups = TRUE, allow_gaps = FALSE)

# Grouped
eu_stock <- ts_as_tbl(EuStockMarkets)
eu_stock <- eu_stock \%>\%
  mutate(date = as_date(
    date_decimal(time)
  ))

time_is_regular(eu_stock$date, g = eu_stock$group, timespan = 1,
                allow_gaps = TRUE)
# This makes sense as no trading occurs on weekends and holidays
time_is_regular(eu_stock$date, g = eu_stock$group,
                timespan = 1,
                allow_gaps = FALSE)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
