% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_ggplot.R
\name{time_ggplot}
\alias{time_ggplot}
\title{Quick time-series ggplot}
\usage{
time_ggplot(
  data,
  time,
  value,
  group = NULL,
  facet = FALSE,
  geom = ggplot2::geom_line,
  ...
)
}
\arguments{
\item{data}{A data frame}

\item{time}{Time variable using \code{tidyselect}.}

\item{value}{Value variable using \code{tidyselect}.}

\item{group}{(Optional) Group variable using \code{tidyselect}.}

\item{facet}{When groups are supplied, should multi-series be
plotted separately or on the same plot?
Default is \code{FALSE}, or together.}

\item{geom}{\code{ggplot2} 'geom' type. Default is \code{geom_line()}.}

\item{...}{Further arguments passed to the chosen 'geom'.}
}
\value{
A \code{ggplot}.
}
\description{
\code{time_ggplot()} is a neat way to quickly
plot aggregate time-series data.
}
\examples{
library(dplyr)
library(timeplyr)
library(ggplot2)
library(lubridate)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 1L)
collapse::set_collapse(nthreads = 1L)
}
# It's as easy as this
AirPassengers \%>\%
  ts_as_tbl() \%>\%
  time_ggplot(time, value)

# And this
EuStockMarkets \%>\%
  ts_as_tbl() \%>\%
  time_ggplot(time, value, group)

# Converting this to monthly averages

EuStockMarkets \%>\%
  ts_as_tbl() \%>\%
  mutate(month = year_month_decimal(time)) \%>\%
  summarise(avg = mean(value),
            .by = c(group, month)) \%>\%
  time_ggplot(month, avg, group)

# zoo example
x.Date <- as.Date("2003-02-01") + c(1, 3, 7, 9, 14) - 1
x <- zoo::zoo(rnorm(5), x.Date)
x \%>\%
  ts_as_tbl() \%>\%
  time_ggplot(time, value)
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
\seealso{
\link{ts_as_tbl}
}
