% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack-tspec.R
\name{unpack_tspec}
\alias{unpack_tspec}
\alias{camel_case_to_snake_case}
\title{Unpack a tibblify specification}
\usage{
unpack_tspec(
  spec,
  ...,
  fields = NULL,
  recurse = TRUE,
  names_sep = NULL,
  names_repair = c("unique", "universal", "check_unique", "unique_quiet",
    "universal_quiet"),
  names_clean = NULL
)

camel_case_to_snake_case(names)
}
\arguments{
\item{spec}{A tibblify specification.}

\item{...}{These dots are for future extensions and must be empty.}

\item{fields}{A string of the fields to unpack.}

\item{recurse}{Should unpack recursively?}

\item{names_sep}{If \code{NULL}, the default, the inner names of fields are used.
If a string, the outer and inner names are pasted together, separated by
\code{names_sep}.}

\item{names_repair}{Used to check that output data frame has valid names.
Must be one of the following options:
\itemize{
\item \code{"unique"} or \code{"unique_quiet"}: (the default) make sure names are unique and not empty,
\item \verb{"universal" or }"unique_quiet"`: make the names unique and syntactic
\item \code{"check_unique"}: no name repair, but check they are unique,
\item a function: apply custom name repair.
}

See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more information.}

\item{names_clean}{A function to clean names after repairing. For example
use \code{\link[=camel_case_to_snake_case]{camel_case_to_snake_case()}}.}

\item{names}{Names to clean}
}
\value{
A tibblify spec.
}
\description{
Unpack a tibblify specification
}
\examples{
spec <- tspec_df(
  tib_lgl("a"),
  tib_row("x", tib_int("b"), tib_chr("c")),
  tib_row("y", tib_row("z", tib_chr("d")))
)

unpack_tspec(spec)
# only unpack `x`
unpack_tspec(spec, fields = "x")
# do not unpack the fields in `y`
unpack_tspec(spec, recurse = FALSE)
}
