% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{try_get}
\alias{try_get}
\title{Try to evaluate an expression a set number of times before failing}
\usage{
try_get(expr, max_tries = 5, error_message = "", retry_message = "Retrying...")
}
\arguments{
\item{expr}{The expression to be evaluated.}

\item{max_tries}{The maximum number of attempts to evaluate the expression before giving up.
Default is \code{5}.}

\item{error_message}{Additional custom error message to be displayed when an error occurs.}

\item{retry_message}{Message displayed when a new try to evaluate the expression would be attempted.}
}
\value{
The evaluated expression if successful,
otherwise it throws an error if all attempts are unsuccessful.
}
\description{
The function is used as a fail-safe if your R code sometimes works and sometimes doesn't,
usually because it depends on a resource that may be temporarily unavailable.
It tries to evaluate the expression \code{max_tries} times.
If all the attempts fail, it throws an error;
if not, the evaluated expression is returned.
}
\examples{
f <- function() {
  value <- runif(1, min = 0, max = 1)
  if (value > 0.5) {
    log_message("value is larger than 0.5")
    return(value)
  } else {
    log_message(
      "value is smaller than 0.5",
      message_type = "error"
    )
  }
}
f_evaluated <- try_get(expr = f())
print(f_evaluated)
}
