% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rd.R
\name{testex-rd-example-helpers}
\alias{testex-rd-example-helpers}
\alias{rd_extract_examples}
\alias{rd_code_as_string}
\alias{split_testonly_as_expr}
\alias{split_testonly}
\title{Rd Example Parsing Helpers}
\usage{
rd_extract_examples(rd)

rd_code_as_string(rd)

split_testonly_as_expr(rd)

split_testonly(rd)
}
\arguments{
\item{rd}{An Rd object}
}
\value{
The examples section of an Rd object

A formatted Rd example

An interlaced list of expressions, either representing example
code or tests. The names of the list are either \verb{\testonly} or \code{RDCODE}
depending on the originating source of the expression.

A list of Rd tag contents
}
\description{
Rd Example Parsing Helpers
}
\section{Functions}{
\itemize{
\item \code{rd_extract_examples()}: Extract examples tag from an Rd file

\item \code{rd_code_as_string()}: Convert an Rd example to string

\item \code{split_testonly_as_expr()}: Split sections of an example into evaluated example code blocks and code
blocks wrapped in \verb{\testonly} \code{Rd_tag}s, reassigning \code{\link{srcref}}s as the
example code is split.

\item \code{split_testonly()}: Split sections of an example into lists of \code{Rd_tag}s. Note that \code{\link{srcref}}s
are split by line number. If a line is split between two sections, it is
attributed to the first section. As this is used primarily for giving line
numbers to test messages, this is sufficient for providing test failures
locations.

}}
\keyword{internal}
