% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing-makewindows.R
\name{makewindows}
\alias{makewindows}
\title{Split Gene Annotations into Fixed-Size Windows}
\usage{
makewindows(allannobed, windsize, nbcputrans = 1, verbose = TRUE,
   saveobjectpath = NA, showtime = FALSE)
}
\arguments{
\item{allannobed}{A data frame which is the result of 'retrieveanno'.}

\item{windsize}{An integer specifying the number of windows into which each
gene annotation should be divided.}

\item{nbcputrans}{Number of CPU cores to use for transcript-level operations.
Defaults to 1.}

\item{verbose}{A logical value indicating whether to display progress
messages. Defaults to `TRUE`.}

\item{saveobjectpath}{A character string specifying the directory path where
the output object should be saved as an `.rds` file. If `NA`, the object is
not saved. Defaults to `NA`.}

\item{showtime}{A logical value indicating whether to display the runtime of
the function. Defaults to `FALSE`.}
}
\value{
A data frame containing the split windows for each gene annotation.
 The output includes fields such as `biotype`, `chr`, `coor1`, `coor2`,
 `transcript`, `gene`, `strand`, and `window`.
}
\description{
This functions uses the annotations filtered from gencode (see retrieveanno).
It removes any ensembl names containing "PAR_Y". It filters out intervals
smaller than windsize and splits each transcript into "windsize" windows.
}
\details{
The function filters out annotations with intervals smaller than the
 specified number of windows (`windsize`). It uses parallel processing to
enhance performance when splitting transcripts into fixed-size windows. The
result includes metadata for each window, such as its chromosome, start and
end coordinates, associated gene, and the window number.

Intermediate functions, such as `.computewindflist` and
`.divideannoinwindows`, handle computation and validation of windows. Gene
intervals with the "PAR_Y" tag are excluded from the analysis.
}
\examples{
\donttest{
exptabpath <- system.file("extdata", "exptab-preprocessing.csv", package="tepr")
gencodepath <- system.file("extdata", "gencode-chr13.gtf", package = "tepr")
windsize <- 200

## Necessary result to call makewindows
allannobed <- retrieveanno(exptabpath, gencodepath, verbose = FALSE)

## Calling makewindows
allwindowsbed <- makewindows(allannobed, windsize, verbose = FALSE)}

}
\seealso{
[retrieveanno]
}
