% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{rose}
\alias{rose}
\title{Rose Diagram}
\usage{
rose(
  x,
  weights = NULL,
  binwidth = NULL,
  bins = NULL,
  axial = TRUE,
  equal_area = TRUE,
  muci = TRUE,
  round_binwidth = 0,
  mtext = "N",
  main = NULL,
  sub = NULL,
  at = seq(0, 360 - 45, 45),
  cborder = TRUE,
  labels = TRUE,
  col = "grey",
  dots = FALSE,
  dot_pch = 1,
  dot_cex = 1,
  dot_col = "slategrey",
  stack = FALSE,
  jitter_factor = 0,
  grid = FALSE,
  grid.lines = seq(0, 135, 45),
  grid.circles = seq(0.2, 1, 0.2),
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{Data to be plotted. A numeric vector containing angles (in degrees).}

\item{weights}{Optional vector of numeric weights associated with x.}

\item{binwidth}{The width of the bins (in degrees).}

\item{bins}{number of arcs to partition the circle width.
Overridden by \code{binwidth}.}

\item{axial}{Logical. Whether data are uniaxial (\code{axial=FALSE})
or biaxial (\code{TRUE}, the default).}

\item{equal_area}{Logical. Whether the radii of the bins are proportional to
the frequencies (\code{equal_area=FALSE}, i.e. equal-angle) or proportional to the
square-root of the frequencies (\code{equal_area=TRUE}, the default).}

\item{muci}{logical. Whether the mean and its 95\% CI are added to the plot
or not.}

\item{round_binwidth}{integer. Number of decimal places of bin width (0 by
default).}

\item{mtext}{character. String to be drawn at the top margin of the plot
(\code{"N"} by default)}

\item{main, sub}{Character string specifying the title and subtitle of the
plot. If \code{sub = NULL}, it will show the bin width.}

\item{at}{Optional vector of angles at which tick marks should be plotted.
Set \code{at=numeric(0)} to suppress tick marks.}

\item{cborder}{logical. Border of rose plot.}

\item{labels}{Either a logical value indicating whether to plot labels
next to the tick marks, or a vector of labels for the tick marks.}

\item{col}{fill color of bins}

\item{dots}{logical. Whether a circular dot plot should be added
(\code{FALSE} is the default).}

\item{dot_cex, dot_pch, dot_col}{Plotting arguments for circular dot plot}

\item{stack}{logical. Groups and stacks the dots if \code{TRUE}. Default is \code{FALSE}.}

\item{jitter_factor}{Add a small amount of noise to the angles' radius that
is added to \code{scale}. Jitter is ignored when \code{stack==TRUE}).
If \code{0}, no jitter is added (by default); if negative, the points fall into
the circle.}

\item{grid}{logical. Whether to add a grid. Default is \code{FALSE}.}

\item{grid.lines, grid.circles}{numeric. Adds a sequence of straight grid
lines and circles based on angles and radii, respectively. Ignored when
\code{grid=FALSE}}

\item{add}{logical.}

\item{...}{Additional arguments passed to \code{\link[spatstat.explore:rose]{spatstat.explore::rose()}}.}
}
\value{
A window (class \code{"owin"}) containing the plotted region or a \code{list}
of the calculated frequencies.
}
\description{
Plots a rose diagram (rose of directions), the analogue of a
histogram or density plot for angular data.
}
\note{
If \code{bins} and \code{binwidth} are \code{NULL}, an optimal bin width will be
calculated using Scott (1979):
\deqn{ w_b = \frac{R}{n^{\frac{1}{3}}}
}
with n being the length of \code{x}, and the range R being either 180 or 360
degree for axial or directional data, respectively.

If \code{"axial" == TRUE}, the binwidth is adjusted to guarantee symmetrical fans.
}
\examples{
x <- rvm(100, mean = 90, k = 5)
rose(x, axial = FALSE, border = TRUE, grid = TRUE)

data("san_andreas")
rose(san_andreas$azi, main = "equal area")
rose(san_andreas$azi, equal_area = FALSE, main = "equal angle")

# weighted frequencies:
rose(san_andreas$azi, weights = 1 / san_andreas$unc, main = "weighted")

# add dots:
rose(san_andreas$azi, dots = TRUE, main = "dot plot", jitter = .2)

# stack dots:
rose(san_andreas$azi,
  dots = TRUE, stack = TRUE, dot_cex = 0.5, dot_pch = 21,
  main = "stacked dot plot"
)
}
