% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{relative_rotation}
\alias{relative_rotation}
\alias{rotation}
\alias{quaternion}
\title{Relative rotation between two rotations}
\usage{
relative_rotation(r1, r2)
}
\arguments{
\item{r1, r2}{Objects of class \code{"euler.pole"}. First rotation is
\code{r1}, followed rotation \code{r2}.}
}
\value{
\code{list}. Euler axes
(geographical coordinates) and Euler angles (in degrees)
}
\description{
Calculates the relative rotation between two rotations, i.e. the
difference from rotation 1 to rotation 2.
}
\examples{
a <- euler_pole(90, 0, angle = 45)
b <- euler_pole(0, 0, 1, geo = FALSE, angle = -15)
relative_rotation(a, b)
relative_rotation(b, a)
}
\references{
Schaeben, H., Kroner, U. and Stephan, T. (2021). Euler Poles of
Tectonic Plates. In B. S. Daza Sagar, Q. Cheng, J. McKinley and F. Agterberg
(Eds.), \emph{Encyclopedia of Mathematical Geosciences. Encyclopedia of Earth Sciences Series}
(pp. 1--7). Springer Nature Switzerland AG 2021.
doi: 10.1007/978-3-030-26050-7_435-1.
}
\seealso{
\code{\link[=euler_pole]{euler_pole()}} for class \code{"euler.pole"}
}
